<?php

use Illuminate\Support\Facades\Route;




/*
|--------------------------------------------------------------------------
| Start Terminal Area
|--------------------------------------------------------------------------
*/


Route::get('/', 'Auth\LoginController@showLoginForm')->name('login');
Route::post('/', 'Auth\LoginController@login');
Route::get('logout', 'Auth\LoginController@logout')->name('logout');

Route::get('register', 'Auth\RegisterController@showRegistrationForm')->name('register');
Route::post('register', 'Auth\RegisterController@register')->middleware('regStatus');
Route::post('check-mail', 'Auth\RegisterController@checkUser')->name('checkUser');

Route::get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');
Route::post('password/email', 'Auth\ForgotPasswordController@sendResetCodeEmail')->name('password.email');
Route::get('password/code-verify', 'Auth\ForgotPasswordController@codeVerify')->name('password.code.verify');
Route::post('password/reset', 'Auth\ResetPasswordController@reset')->name('password.update');
Route::get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
Route::post('password/verify-code', 'Auth\ForgotPasswordController@verifyCode')->name('password.verify.code');
Route::middleware('terminal')->group(function () {
    Route::get('authorization', 'AuthorizationController@authorizeForm')->name('authorization');
    Route::get('resend-verify', 'AuthorizationController@sendVerifyCode')->name('send.verify.code');
    Route::post('verify-email', 'AuthorizationController@emailVerification')->name('verify.email');
    Route::post('verify-sms', 'AuthorizationController@smsVerification')->name('verify.sms');
    Route::post('verify-g2fa', 'AuthorizationController@g2faVerification')->name('go2fa.verify');

    Route::middleware(['checkTerminalStatus'])->group(function () {
        Route::get('dashboard', 'TerminalController@home')->name('home');
        Route::get('check/insight', 'TerminalController@checkInsight')->name('check.insight');
        Route::get('business/api/key', 'TerminalController@apiKey')->name('api.key');
        Route::post('generate/api/key', 'TerminalController@generateApiKey')->name('generate.key');

        Route::get('profile-setting', 'TerminalController@profile')->name('profile.setting');
        Route::post('profile-setting', 'TerminalController@submitProfile');
        Route::get('change-password', 'TerminalController@changePassword')->name('change.password');
        Route::post('change-password', 'TerminalController@submitPassword');

        //2FA
        Route::get('twofactor', 'TerminalController@show2faForm')->name('twofactor');
        Route::post('twofactor/enable', 'TerminalController@create2fa')->name('twofactor.enable');
        Route::post('twofactor/disable', 'TerminalController@disable2fa')->name('twofactor.disable');

        //all wallets
        Route::get('/all/wallets', 'TerminalController@allWallets')->name('all.wallets');

       // Withdraw
       Route::middleware('module:withdraw_money')->group(function(){
           Route::get('/withdraw/money', 'TerminalWithdrawController@withdrawMoney')->name('withdraw.money');
           Route::get('/withdraw/methods', 'TerminalWithdrawController@withdrawMethods')->name('withdraw.methods');
           Route::get('/add/withdraw-method', 'TerminalWithdrawController@addWithdrawMethod')->name('add.withdraw.method');
           Route::post('/add/withdraw-method', 'TerminalWithdrawController@withdrawMethodStore');
           Route::get('/edit/withdraw-method/{id}', 'TerminalWithdrawController@withdrawMethodEdit')->name('withdraw.edit');
           Route::post('/withdraw-method/update', 'TerminalWithdrawController@withdrawMethodUpdate')->name('withdraw.update');
           Route::post('/withdraw/store', 'TerminalWithdrawController@withdrawStore')->name('withdraw.store')->middleware('kyc');
           Route::get('/withdraw/preview', 'TerminalWithdrawController@withdrawPreview')->name('withdraw.preview');
           Route::post('/withdraw/preview', 'TerminalWithdrawController@withdrawSubmit');
           Route::get('/withdraw/done', 'TerminalWithdrawController@withdrawSubmitDone')->name('withdraw.submit.done');
           Route::get('/withdraw/history', 'TerminalWithdrawController@withdrawLog')->name('withdraw.history');
       });

        //kyc
        Route::get('/fill-up/kyc', 'TerminalController@kycForm')->name('kyc');
        Route::post('/fill-up/kyc', 'TerminalController@kycFormSubmit');

        //QR code
        Route::get('/qr-code', 'TerminalController@qrCodeGenerate')->name('qr');
        Route::get('/download/qr-code', 'TerminalController@downLoadQrJpg')->name('qr.jpg');

       Route::get('/transaction/history', 'TerminalController@trxHistory')->name('transactions');

    });
});