<?php
namespace App\Http\Controllers\Admin;

use App\Models\Wallet;
use App\Models\Deposit;
use App\Models\Gateway;
use App\Models\EmailLog;
use App\Models\Terminal;
use App\Models\UserLogin;
use App\Models\Withdrawal;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\GeneralSetting;
use App\Models\WithdrawMethod;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;


class ManageTerminalController extends Controller
{
    public function allTerminal()
    {
        $pageTitle = 'Manage Terminal';
        $emptyMessage = 'No terminal found';
        $users = Terminal::orderBy('id','desc')->paginate(getPaginate());
        return view('admin.terminal.list', compact('pageTitle', 'emptyMessage', 'users'));
    }

    public function activeTerminal()
    {
        $pageTitle = 'Manage Active Terminal';
        $emptyMessage = 'No active terminal found';
        $users = Terminal::active()->orderBy('id','desc')->paginate(getPaginate());
        return view('admin.terminal.list', compact('pageTitle', 'emptyMessage', 'users'));
    }

    public function bannedTerminal()
    {
        $pageTitle = 'Banned Terminal';
        $emptyMessage = 'No banned terminal found';
        $users = Terminal::banned()->orderBy('id','desc')->paginate(getPaginate());
        return view('admin.terminal.list', compact('pageTitle', 'emptyMessage', 'users'));
    }

    public function emailUnverifiedTerminal()
    {
        $pageTitle = 'Email Unverified Terminal';
        $emptyMessage = 'No email unverified terminal found';
        $users = Terminal::emailUnverified()->orderBy('id','desc')->paginate(getPaginate());
        return view('admin.terminal.list', compact('pageTitle', 'emptyMessage', 'users'));
    }
    public function emailVerifiedTerminal()
    {
        $pageTitle = 'Email Verified Terminal';
        $emptyMessage = 'No email verified terminal found';
        $users = Terminal::emailVerified()->orderBy('id','desc')->paginate(getPaginate());
        return view('admin.terminal.list', compact('pageTitle', 'emptyMessage', 'users'));
    }


    public function smsUnverifiedTerminal()
    {
        $pageTitle = 'SMS Unverified Terminal';
        $emptyMessage = 'No sms unverified terminal found';
        $users = Terminal::smsUnverified()->orderBy('id','desc')->paginate(getPaginate());
        return view('admin.terminal.list', compact('pageTitle', 'emptyMessage', 'users'));
    }


    public function smsVerifiedTerminal()
    {
        $pageTitle = 'SMS Verified Terminal';
        $emptyMessage = 'No sms verified terminal found';
        $users = Terminal::smsVerified()->orderBy('id','desc')->paginate(getPaginate());
        return view('admin.terminal.list', compact('pageTitle', 'emptyMessage', 'users'));
    }

    


    public function search(Request $request, $scope)
    {
        $search = $request->search;
        $terminal = Terminal::where(function ($user) use ($search) {
            $user->where('username', 'like', "%$search%")
                ->orWhere('email', 'like', "%$search%");
        });
        $pageTitle = '';
        if ($scope == 'active') {
            $pageTitle = 'Active ';
            $terminal = $terminal->where('status', 1);
        }elseif($scope == 'banned'){
            $pageTitle = 'Banned';
            $terminal = $terminal->where('status', 0);
        }elseif($scope == 'emailUnverified'){
            $pageTitle = 'Email Unverified ';
            $terminal = $terminal->where('ev', 0);
        }elseif($scope == 'smsUnverified'){
            $pageTitle = 'SMS Unverified ';
            $terminal = $terminal->where('sv', 0);
        }elseif($scope == 'withBalance'){
            $pageTitle = 'With Balance ';
            $terminal = $terminal->where('balance','!=',0);
        }

        $users = $terminal->paginate(getPaginate());
        $pageTitle .= 'Terminal Search - ' . $search;
        $emptyMessage = 'No search result found';
        return view('admin.terminal.list', compact('pageTitle', 'search', 'scope', 'emptyMessage', 'users'));
    }


    public function detail($id)
    {
        $pageTitle = 'Terminal Detail';
        $user = Terminal::findOrFail($id);
        $totalWithdraw = Withdrawal::where('user_id',$user->id)->where('user_type','TERMINAL')->where('status',1)->sum('amount');
        $totalTransaction = Transaction::where('user_id',$user->id)->where('user_type','TERMINAL')->count();
        $getPaid = Transaction::where('user_id',$user->id)->where('user_type','TERMINAL')->where('operation_type','terminal_payment')->whereHas('wallet')->get();
        $totalGetPaid[] = 0;
        foreach($getPaid as $paid){
            $totalGetPaid[] = $paid->amount * $paid->wallet->currency->rate;
        }
        $countries = json_decode(file_get_contents(resource_path('views/partials/country.json')));
        $wallets = Wallet::where('user_type','TERMINAL')->where('user_id',$user->id)->get();
        return view('admin.terminal.detail', compact('pageTitle', 'user','totalWithdraw','totalTransaction','countries','wallets','totalGetPaid','totalGetPaid'));
    }


    public function update(Request $request, $id)
    {
        $user = Terminal::findOrFail($id);

        $countryData = json_decode(file_get_contents(resource_path('views/partials/country.json')));

        $request->validate([
            'firstname' => 'required|max:50',
            'lastname' => 'required|max:50',
            'email' => 'required|email|max:90|unique:terminal,email,' . $user->id,
            'mobile' => 'required|unique:terminal,mobile,' . $user->id,
            'country' => 'required',
        ]);
        $countryCode = $request->country;
        $user->mobile = $request->mobile;
        $user->country_code = $countryCode;
        $user->firstname = $request->firstname;
        $user->lastname = $request->lastname;
        $user->email = $request->email;
        $user->address = [
                            'address' => $request->address,
                            'city' => $request->city,
                            'state' => $request->state,
                            'zip' => $request->zip,
                            'country' => @$countryData->$countryCode->country,
                        ];
        $user->status = $request->status ? 1 : 0;
        $user->ev = $request->ev ? 1 : 0;
        $user->sv = $request->sv ? 1 : 0;
        $user->ts = $request->ts ? 1 : 0;
        $user->tv = $request->tv ? 1 : 0;
        $user->save();

        $notify[] = ['success', 'Terminal detail has been updated'];
        return redirect()->back()->withNotify($notify);
    }

    public function addSubBalance(Request $request, $id)
    {
        $request->validate(['amount' => 'required|numeric|gt:0']);

        $user = Terminal::findOrFail($id);
        $wallet = Wallet::find($request->wallet_id);
        if(!$wallet){
            $notify[]=['error','Sorry wallet not found'];
            return back()->withNotify($notify);
        }
        $amount = $request->amount;
        $trx = getTrx();

        $transaction = new Transaction();

        if ($request->act) {
            $wallet->balance += $amount;

            $notify[] = ['success', $wallet->currency->currency_symbol . $amount . ' has been added to this wallet'];

            $transaction->trx_type = '+';
            $transaction->operation_type = 'add_balance';
            $transaction->details = 'Added Balance Via Admin';

            $notifyTemplate = 'BAL_ADD';

            $notifyParams = [
                'trx' => $trx,
                'amount' => showAmount($amount,$wallet->currency),
                'currency' => $wallet->currency->currency_code,
                'post_balance' => showAmount($wallet->balance,$wallet->currency),
            ];


        } else {
            if ($amount > $wallet->balance) {
                $notify[] = ['error', 'This wallet has insufficient balance.'];
                return back()->withNotify($notify);
            }
            $wallet->balance -= $amount;

            $transaction->trx_type = '-';
            $transaction->operation_type = 'sub_balance';
            $transaction->details = 'Subtract Balance Via Admin';

            $notifyTemplate = 'BAL_SUB';

            $notifyParams = [
                'trx' => $trx,
                'amount' => showAmount($amount,$wallet->currency),
                'currency' => $wallet->currency->currency_code,
                'post_balance' => showAmount($wallet->balance,$wallet->currency)
            ];

            $notify[] = ['success', $wallet->currency->currency_symbol. $amount . ' has been subtracted from this wallet'];
        }
        $wallet->save();

        $transaction->user_id = $user->id;
        $transaction->user_type = 'TERMINAL';
        $transaction->wallet_id = $wallet->id;
        $transaction->currency_id = $wallet->currency_id;
        $transaction->before_charge = $amount;
        $transaction->amount = $amount;
        $transaction->charge_type = '+';
        $transaction->post_balance =  $wallet->balance;
        $transaction->charge =  0;
        $transaction->trx = $trx;
        $transaction->save();

        notify($user, $notifyTemplate,$notifyParams);


        return back()->withNotify($notify);
    }


    public function terminalLoginHistory($id)
    {
        $user = Terminal::findOrFail($id);
        $pageTitle = 'Terminal Login History - ' . $user->username;
        $emptyMessage = 'No Terminal login found.';
        $login_logs = UserLogin::where('terminal_id',$user->id)->orderBy('id','desc')->paginate(getPaginate());
        return view('admin.terminal.logins', compact('pageTitle', 'emptyMessage', 'login_logs'));
    }



    public function showEmailSingleForm($id)
    {
        $user = Terminal::findOrFail($id);
        $pageTitle = 'Send Email To: ' . $user->username;
        return view('admin.terminal.email_single', compact('pageTitle', 'user'));
    }

    public function sendEmailSingle(Request $request, $id)
    {
        $request->validate([
            'message' => 'required|string|max:65000',
            'subject' => 'required|string|max:190',
        ]);

        $user = Terminal::findOrFail($id);
        sendGeneralEmail($user->email, $request->subject, $request->message, $user->username);
        $notify[] = ['success', $user->username . ' will receive an email shortly.'];
        return back()->withNotify($notify);
    }

    public function transactions(Request $request, $id)
    {
        $user = Terminal::findOrFail($id);
        if ($request->search) {
            $search = $request->search;
            $pageTitle = 'Search Terminal Transactions : ' . $user->username;
            $transactions = $user->transactions()->where('trx', $search)->with('terminal')->orderBy('id','desc')->paginate(getPaginate());
            $emptyMessage = 'No transactions';
            return view('admin.reports.terminal_transactions', compact('pageTitle', 'search', 'user', 'transactions', 'emptyMessage'));
        }
        $pageTitle = 'Terminal Transactions : ' . $user->username;
        $transactions = $user->transactions()->with('terminal')->orderBy('id','desc')->paginate(getPaginate());
        $emptyMessage = 'No transactions';
        return view('admin.reports.terminal_transactions', compact('pageTitle', 'user', 'transactions', 'emptyMessage'));
    }

    public function deposits(Request $request, $id)
    {
        $user = Terminal::findOrFail($id);
        $userId = $user->id;
        if ($request->search) {
            $search = $request->search;
            $pageTitle = 'Search Terminal Deposits : ' . $user->username;
            $deposits = $user->deposits()->where('trx', $search)->orderBy('id','desc')->paginate(getPaginate());
            $emptyMessage = 'No deposits';
            return view('admin.deposit.log', compact('pageTitle', 'search', 'user', 'deposits', 'emptyMessage','userId'));
        }

        $pageTitle = 'Terminal Deposit : ' . $user->username;
        $deposits = $user->deposits()->orderBy('id','desc')->paginate(getPaginate());
        $successful = $user->deposits()->orderBy('id','desc')->sum('amount');
        $pending = $user->deposits()->orderBy('id','desc')->sum('amount');
        $rejected = $user->deposits()->orderBy('id','desc')->sum('amount');
        $emptyMessage = 'No deposits';
        $scope = 'all';
        return view('admin.deposit.log', compact('pageTitle', 'user', 'deposits', 'emptyMessage','userId','scope','successful','pending','rejected'));
    }


    public function depViaMethod($method,$type = null,$userId){
        $method = Gateway::where('alias',$method)->firstOrFail();        
        $user = Terminal::findOrFail($userId);
        if ($type == 'approved') {
            $pageTitle = 'Approved Payment Via '.$method->name;
            $deposits = Deposit::where('method_code','>=',1000)->where('user_type','TERMINAL')->where('user_id',$user->id)->where('method_code',$method->code)->where('status', 1)->orderBy('id','desc')->with(['terminal', 'gateway'])->paginate(getPaginate());
        }elseif($type == 'rejected'){
            $pageTitle = 'Rejected Payment Via '.$method->name;
            $deposits = Deposit::where('method_code','>=',1000)->where('user_type','TERMINAL')->where('user_id',$user->id)->where('method_code',$method->code)->where('status', 3)->orderBy('id','desc')->with(['terminal', 'gateway'])->paginate(getPaginate());
        }elseif($type == 'successful'){
            $pageTitle = 'Successful Payment Via '.$method->name;
            $deposits = Deposit::where('status', 1)->where('user_type','TERMINAL')->where('user_id',$user->id)->where('method_code',$method->code)->orderBy('id','desc')->with(['terminal', 'gateway'])->paginate(getPaginate());
        }elseif($type == 'pending'){
            $pageTitle = 'Pending Payment Via '.$method->name;
            $deposits = Deposit::where('method_code','>=',1000)->where('user_type','TERMINAL')->where('user_id',$user->id)->where('method_code',$method->code)->where('status', 2)->orderBy('id','desc')->with(['terminal', 'gateway'])->paginate(getPaginate());
        }else{
            $pageTitle = 'Payment Via '.$method->name;
            $deposits = Deposit::where('status','!=',0)->where('user_type','TERMINAL')->where('user_id',$user->id)->where('method_code',$method->code)->orderBy('id','desc')->with(['terminal', 'gateway'])->paginate(getPaginate());
        }
        $pageTitle = 'Deposit History: '.$user->username.' Via '.$method->name;
        $methodAlias = $method->alias;
        $emptyMessage = 'Deposit Log';
        return view('admin.deposit.log', compact('pageTitle', 'emptyMessage', 'deposits','methodAlias','userId'));
    }



    public function withdrawals(Request $request, $id)
    {
        $user = Terminal::findOrFail($id);
        if ($request->search) {
            $search = $request->search;
            $pageTitle = 'Search Terminal Withdrawals : ' . $user->username;
            $withdrawals = $user->withdrawals()->where('trx', 'like',"%$search%")->orderBy('id','desc')->paginate(getPaginate());
            $emptyMessage = 'No withdrawals';
            return view('admin.withdraw.withdrawals', compact('pageTitle', 'user', 'search', 'withdrawals', 'emptyMessage'));
        }
        $pageTitle = 'Terminal Withdrawals : ' . $user->username;
        $withdrawals = $user->withdrawals()->orderBy('id','desc')->paginate(getPaginate());
        $emptyMessage = 'No withdrawals';
        $userId = $user->id;
        return view('admin.withdraw.withdrawals', compact('pageTitle', 'user', 'withdrawals', 'emptyMessage','userId'));
    }

    public  function withdrawalsViaMethod($method,$type,$userId){
        $method = WithdrawMethod::findOrFail($method);
        $user = Terminal::findOrFail($userId);
        if ($type == 'approved') {
            $pageTitle = 'Approved Withdrawal of '.$user->username.' Via '.$method->name;
            $withdrawals = Withdrawal::where('status', 1)->where('user_type','TERMINAL')->where('user_id',$user->id)->with(['terminal','method'])->orderBy('id','desc')->paginate(getPaginate());
        }elseif($type == 'rejected'){
            $pageTitle = 'Rejected Withdrawals of '.$user->username.' Via '.$method->name;
            $withdrawals = Withdrawal::where('status', 3)->where('user_type','TERMINAL')->where('user_id',$user->id)->with(['terminal','method'])->orderBy('id','desc')->paginate(getPaginate());

        }elseif($type == 'pending'){
            $pageTitle = 'Pending Withdrawals of '.$user->username.' Via '.$method->name;
            $withdrawals = Withdrawal::where('status', 2)->where('user_type','TERMINAL')->where('user_id',$user->id)->with(['terminal','method'])->orderBy('id','desc')->paginate(getPaginate());
        }else{
            $pageTitle = 'Withdrawals of '.$user->username.' Via '.$method->name;
            $withdrawals = Withdrawal::where('status', '!=', 0)->where('user_type','TERMINAL')->where('user_id',$user->id)->with(['terminal','method'])->orderBy('id','desc')->paginate(getPaginate());
        }
        $emptyMessage = 'Withdraw Log Not Found';
        return view('admin.withdraw.withdrawals', compact('pageTitle', 'withdrawals', 'emptyMessage','method'));
    }

    public function showEmailAllForm()
    {
        $pageTitle = 'Send Email To All Terminal';
        return view('admin.terminal.email_all', compact('pageTitle'));
    }

    public function sendEmailAll(Request $request)
    {
        $request->validate([
            'message' => 'required|string|max:65000',
            'subject' => 'required|string|max:190',
        ]);

        foreach (Terminal::where('status', 1)->cursor() as $user) {
            sendGeneralEmail($user->email, $request->subject, $request->message, $user->username);
        }

        $notify[] = ['success', 'All Terminal will receive an email shortly.'];
        return back()->withNotify($notify);
    }

    public function login($id){
        $user = Terminal::findOrFail($id);
        Auth::guard('terminal')->login($user);
        return redirect()->route('terminal.home');
    }

    public function emailLog($id){
        $user = Terminal::findOrFail($id);
        $pageTitle = 'Email log of '.$user->username;
        $logs = EmailLog::where('user_id',$id)->where('user_type','TERMINAL')->with('agent')->orderBy('id','desc')->paginate(getPaginate());
        $emptyMessage = 'No data found';
        return view('admin.terminal.email_log', compact('pageTitle','logs','emptyMessage','user'));
    }

    public function emailDetails($id){
        $email = EmailLog::findOrFail($id);
        $pageTitle = 'Email details';
        return view('admin.terminal.email_details', compact('pageTitle','email'));
    }

}
