<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
class RedirectIfTerminal
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = 'terminal')
    {
        if (Auth::guard($guard)->check()) {
            return redirect()->route('terminal.home');
        }
        return $next($request);
    }
}
