<?php

namespace App\Http\Controllers\User;
use App\Http\Controllers\Controller;
use App\Lib\UserActionProcess;
use App\Models\GeneralSetting;
use App\Models\Terminal;
use App\Models\Transaction;
use App\Models\TransactionCharge;
use App\Models\UserAction;
use App\Models\Wallet;
use Illuminate\Http\Request;

class MakePaymentController extends Controller
{
    public function __construct() {
        $this->activeTemplate = activeTemplate();
    }

    public function checkUser(Request $request){
        $exist['data'] = Terminal::where('username',$request->agent)->orWhere('email',$request->agent)->first();
        return response($exist);
    }

    public function paymentFrom()
    {
        $pageTitle = "Make Payment";
        $paymentCharge = TransactionCharge::where('slug','make_payment')->first();
        $wallets = Wallet::checkWallet(['user'=>auth()->user(),'type'=>'USER'])->where('balance','>',0)->orderBy('balance','DESC')->get();
        return  view($this->activeTemplate.'user.makepayment.make_payment',compact('pageTitle','wallets','paymentCharge'));
    }

    public function paymentConfirm(Request $request)
    {

        $request->validate([
            'wallet_id' => 'required|integer',
            'amount' => 'required|gt:0',
            'terminal' => 'required',
            'otp_type'=>'nullable|in:email,sms,2fa'
        ]);
        $user = auth()->user();

        $paymentCharge = TransactionCharge::where('slug','make_payment')->firstOrFail();
        $wallet = Wallet::checkWallet(['user'=>$user,'type'=>'USER'])->find($request->wallet_id);
        if(!$wallet){
            $notify[]=['error','Wallet Not found'];
            return back()->withNotify($notify)->withInput();
        }

        $terminal = Terminal::where('username',$request->terminal)->orWhere('email',$request->terminal)->first();
        if(!$terminal){
            $notify[]=['error','Sorry! Terminal Not Found'];
            return back()->withNotify($notify)->withInput();
        }

       $terminalWallet = Wallet::checkWallet(['user'=>$terminal,'type'=>'TERMINAL'])->where('currency_id', $wallet->currency->id)->first();
       if(!$terminalWallet){
            $terminalWallet = Wallet::selfCreate([$wallet->currency_id,$wallet->currency->currency_code,'TERMINAL',$terminal->id]);
        }

        //user charge
       $rate = $wallet->currency->rate;

       $fixedCharge = currencyConverter($paymentCharge->fixed_charge,$rate);
       $totalCharge = chargeCalculator($request->amount,$paymentCharge->percent_charge,$fixedCharge);

       //terminal charge
       $terminalFixedCharge = currencyConverter($paymentCharge->terminal_fixed_charge,$rate);
       $terminalTotalCharge = chargeCalculator($request->amount,$paymentCharge->terminal_percent_charge,$terminalFixedCharge);


        if($wallet->currency->currency_type == 1){
            $precision = 2;
        } else {
            $precision = 8;
        }
        $userTotalAmount = getAmount($request->amount + $totalCharge,$precision);
        $terminalTotalAmount = getAmount($request->amount - $terminalTotalCharge,$precision);
        $totalCharge = getAmount($totalCharge,$precision);
        $terminalTotalCharge = getAmount($terminalTotalCharge,$precision);

       if($userTotalAmount > $wallet->balance){
            $notify[]=['error','Sorry! insufficient balance in wallet'];
            return back()->withNotify($notify)->withInput();
       }

       $userAction = new UserActionProcess();
       $userAction->user_id = auth()->user()->id;
       $userAction->user_type = userGuard()['type'];
       $userAction->act = 'make_payment';
       $userAction->details = [
            'wallet_id'=>$wallet->id,
            'amount'=>$request->amount,
            'userTotalAmount'=>$userTotalAmount,
            'totalCharge'=>$totalCharge,
            'terminal_id'=>$terminal->id,
            'terminalTotalCharge'=>$terminalTotalCharge,
            'done_route'=>route('user.payment.done'),
       ];
       $userAction->type = $request->otp_type;
       $userAction->submit();

       return redirect($userAction->next_route);
    }

    public function paymentDone(){
        $userAction = UserAction::where('user_id',auth()->user()->id)->where('id',session('action_id'))->first();
        if(!$userAction){
            $notify[] = ['error','Sorry! Unable to Process'];
            return back()->withNotify($notify);
        }
        $details = $userAction->details;

        $user = auth()->user();
        $wallet = Wallet::checkWallet(['user'=>$user,'type'=>'USER'])->find($details->wallet_id);
        if(!$wallet){
            $notify[]=['error','Wallet Not found'];
            return back()->withNotify($notify)->withInput();
        }


        $terminal = Terminal::where('id',$details->terminal_id)->first();
        if(!$terminal){
            $notify[]=['error','Sorry! Terminal Not Found'];
            return back()->withNotify($notify)->withInput();
        }

       $terminalWallet = Wallet::checkWallet(['user'=>$terminal,'type'=>'TERMINAL'])->where('currency_id', $wallet->currency->id)->first();
       if(!$terminalWallet){
            $terminalWallet = Wallet::selfCreate([$wallet->currency_id,$wallet->currency->currency_code,'TERMINAL',$terminal->id]);
        }

        $wallet->balance -=  $details->userTotalAmount;
        $wallet->save();

        $senderTrx = new Transaction();
        $senderTrx->user_id = auth()->id();
        $senderTrx->user_type = 'USER';
        $senderTrx->wallet_id = $wallet->id;
        $senderTrx->currency_id = $wallet->currency_id;
        $senderTrx->before_charge = $details->amount;
        $senderTrx->amount = $details->userTotalAmount;
        $senderTrx->post_balance = $wallet->balance;
        $senderTrx->charge =  $details->totalCharge;
        $senderTrx->charge_type = '+';
        $senderTrx->trx_type = '-';
        $senderTrx->operation_type = 'make_payment';
        $senderTrx->details = 'Payment successful to';
        $senderTrx->receiver_id = $terminal->id;
        $senderTrx->receiver_type = "TERMINAL";
        $senderTrx->trx = getTrx();
        $senderTrx->save();

        $terminalWallet->balance += $details->amount;
        $terminalWallet->save();

        $terminalTrx = new Transaction();
        $terminalTrx->user_id = $terminal->id;
        $terminalTrx->user_type = 'TERMINAL';
        $terminalTrx->wallet_id = $terminalWallet->id;
        $terminalTrx->currency_id = $terminalWallet->currency_id;
        $terminalTrx->before_charge = $details->amount;
        $terminalTrx->amount = $details->amount;
        $terminalTrx->post_balance = $terminalWallet->balance;
        $terminalTrx->charge =  0;
        $terminalTrx->charge_type =  '+';
        $terminalTrx->trx_type = '+';
        $terminalTrx->operation_type = 'make_payment';
        $terminalTrx->details = 'Payment successful from';
        $terminalTrx->receiver_id = auth()->id();
        $terminalTrx->receiver_type = "USER";
        $terminalTrx->trx = $senderTrx->trx;
        $terminalTrx->save();

        if ($details->terminalTotalCharge > 0) {
            $terminalWallet->balance -= $details->terminalTotalCharge;
            $terminalWallet->save();
            $terminalTrx = new Transaction();
            $terminalTrx->user_id = $terminal->id;
            $terminalTrx->user_type = 'TERMINAL';
            $terminalTrx->wallet_id = $terminalWallet->id;
            $terminalTrx->currency_id = $terminalWallet->currency_id;
            $terminalTrx->before_charge = $details->terminalTotalCharge;
            $terminalTrx->amount = $details->terminalTotalCharge;
            $terminalTrx->post_balance = $terminalWallet->balance;
            $terminalTrx->charge =  0;
            $terminalTrx->charge_type =  '+';
            $terminalTrx->trx_type = '-';
            $terminalTrx->operation_type = 'payment_charge';
            $terminalTrx->details = 'Payment charge';
            $terminalTrx->receiver_id = auth()->id();
            $terminalTrx->receiver_type = "USER";
            $terminalTrx->trx = $senderTrx->trx;
            $terminalTrx->save();
        }


        notify($user,'MAKE_PAYMENT',[
            'amount'=> showAmount($details->amount,$wallet->currency),
            'charge' => showAmount($details->totalCharge,$wallet->currency),
            'curr_code' => $wallet->currency->currency_code,
            'terminal' => $terminal->fullname.' ( '.$terminal->username.' )',
            'trx' => $senderTrx->trx,
            'time' => showDateTime($senderTrx->created_at,'d/M/Y @h:i a'),
            'balance' => showAmount($wallet->balance,$wallet->currency),
        ]);

        notify($terminal,'MAKE_PAYMENT_TERMINAL',[
            'amount'=> showAmount($details->amount,$wallet->currency),
            'charge' => showAmount($details->terminalTotalCharge,$wallet->currency),
            'curr_code' => $wallet->currency->currency_code,
            'user' => $user->fullname.' ( '.$user->username.' )',
            'trx' => $senderTrx->trx,
            'time' => showDateTime($senderTrx->created_at,'d/M/Y @h:i a'),
            'balance' => showAmount($terminalWallet->balance,$wallet->currency),
        ]);

        $notify[]=['success','Payment successful'];
        return redirect()->route('user.payment')->withNotify($notify);
    }

}
