<?php

namespace App\Http\Traits;

use App\Lib\UserActionProcess;
use App\Models\AdminNotification;
use App\Models\Currency;
use App\Models\GeneralSetting;
use App\Models\Transaction;
use App\Models\UserWithdrawMethod;
use App\Models\Wallet;
use App\Models\WithdrawMethod;
use App\Models\Withdrawal;
use App\Rules\FileTypeValidate;
use Illuminate\Http\Request;


trait WithdrawProcess{


    public function addWithdrawMethod()
    {
        $pageTitle = "Add Withdraw Method";
        $withdrawMethod = WithdrawMethod::whereJsonContains('user_guards',userGuard()['guard'])->where('status',1)->get();
        $currencies = Currency::pluck('id','currency_code');
        return view($this->activeTemplate.strtolower(userGuard()['type']).'.withdraw.add_method', compact('pageTitle','withdrawMethod','currencies'));
    }


	public function withdrawMethodStore(Request $request)
    {
        $rules = ['name'=>'required','method_id'=>'required','currency_id'=>'required'];
        $storeHelper = $this->storeHelper($request, $rules);
        $this->validate($request, $storeHelper['rules']);
        $userMethod = new UserWithdrawMethod();
        $userMethod->name =$request->name;
        $userMethod->user_id = userGuard()['user']->id;
        $userMethod->user_type = userGuard()['type'];
        $userMethod->method_id = $request->method_id;
        $userMethod->currency_id = $request->currency_id;
        $userMethod->user_data = $storeHelper['user_data'];
        $userMethod->save();
        $notify[]=['success','Withdraw method Updated successfully'];
        return redirect(route(strtolower(userGuard()['type']).'.withdraw.methods'))->withNotify($notify);

    }

    protected function storeHelper($request,$rules,$isUpdate = false)
    {
        $withdrawMethod = WithdrawMethod::where('id',$request->method_id)->whereJsonContains('user_guards',userGuard()['guard'])->where('status',1)->firstOrFail();
        if (!$withdrawMethod) {
            $notify[]=['error','Something went wrong!'];
            return back()->withNotify($notify);
        }

        if ($withdrawMethod->user_data != null) {
            foreach ($withdrawMethod->user_data as $key => $cus) {
            	if ($isUpdate && $cus->type == 'file') {
            		$rules[$key] = ['nullable'];
            	}else{
            		$rules[$key] = [$cus->validation];
            	}
                if ($cus->type == 'file') {
                    array_push($rules[$key], 'image');
                    array_push($rules[$key], new FileTypeValidate(['jpg','jpeg','png']));
                    array_push($rules[$key], 'max:2048');
                }
                if ($cus->type == 'text') {

                    array_push($rules[$key], 'max:191');
                }
                if ($cus->type == 'textarea') {
                    array_push($rules[$key], 'max:300');
                }
            }
        }


        $directory = date("Y")."/".date("m")."/".date("d");
        $path = imagePath()['verify']['withdraw']['path'].'/'.$directory;
        $collection = collect($request);
        $reqField = [];
        if ($withdrawMethod->user_data != null) {
            foreach ($collection as $k => $v) {
                foreach ($withdrawMethod->user_data as $inKey => $inVal) {
                    if (($k != $inKey) && ($inVal->type != 'file')) {
                        continue;
                    } else {
                        if ($inVal->type == 'file') {
                            if ($request->hasFile($inKey)) {
                                try {
                                    $reqField[$inKey] = [
                                        'field_name' =>$directory.'/'.uploadImage($request[$inKey], $path),
                                        'type' => $inVal->type,
                                        'validation' => $inVal->validation
                                    ];

                                } catch (\Exception $exp) {
                                    $notify[] = ['error', 'Could not upload your ' . $request[$inKey]];
                                    return back()->withNotify($notify)->withInput();
                                }
                            }else{
                            	$reqField[$inKey] = [
                                    'field_name' =>@$userMethod->user_data->$inKey->field_name,
                                    'type' => $inVal->type,
                                    'validation' => $inVal->validation
                                ];
                            }
                        } else {
                            $reqField[$inKey] = [
                                'field_name' => $v,
                                'type' => $inVal->type,
                                'validation' => $inVal->validation
                            ];

                        }
                    }
                }
            }

        }

        return ['user_data'=>$reqField,'rules'=>$rules];
    }



    public function withdrawMethodEdit($id)
    {
        $pageTitle = 'Withdraw Method Edit';
        $userMethod = UserWithdrawMethod::myWithdrawMethod()->where('id',$id)->first();
        if (!$userMethod) {
            $notify[]=['error','Withdraw method not found'];
            return back()->withNotify($notify);
        }
        $withdrawMethod = WithdrawMethod::whereJsonContains('user_guards',userGuard()['guard'])->where('status',1)->get();
        $currencies = Currency::pluck('id','currency_code');
        return view($this->activeTemplate.strtolower(userGuard()['type']).'.withdraw.withdraw_method_edit', compact('pageTitle','userMethod','withdrawMethod','currencies'));
    }

    public function withdrawMethodUpdate(Request $request)
    {
        $userMethod = UserWithdrawMethod::where('user_type',userGuard()['type'])->where('user_id',userGuard()['user']->id)->where('id',$request->id)->first();
        if (!$userMethod) {
            $notify[]=['error','Withdraw method not found'];
            return back()->withNotify($notify);
        }


        $rules = ['name'=>'required'];
        $storeHelper = $this->storeHelper($request, $rules,true);

        $this->validate($request, $storeHelper['rules']);

        $userMethod->name         = $request->name;
        $userMethod->user_id      = userGuard()['user']->id;
        $userMethod->user_type    = userGuard()['type'];
        $userMethod->user_data    = $storeHelper['user_data'];
        $userMethod->status       = $request->status ? 1:0;
        $userMethod->save();
        $notify[]=['success','Withdraw method added successfully'];
        return back()->withNotify($notify);
    }


    public function withdrawStore(Request $request)
    {

        $this->validate($request, [
            'method_id' => 'required',
            'user_method_id' => 'required',
            'amount' => 'required|numeric'
        ]);

        $user = userGuard()['user'];

        $method = WithdrawMethod::where('id', $request->method_id)->where('status', 1)->whereJsonContains('user_guards',userGuard()['guard'])->firstOrFail();

        $userMethod = UserWithdrawMethod::myWithdrawMethod()->findOrFail($request->user_method_id);
        $currency = Currency::find($userMethod->currency_id);
        if(!$currency){
            $notify[] = ['error', 'Currency not found'];
            return back()->withNotify($notify);
        }
        $wallet = Wallet::hasCurrency()->where('user_type',userGuard()['type'])->where('user_id',userGuard()['user']->id)->where('currency_id',$currency->id)->first();
        if(!$wallet){
            $notify[] = ['error', 'Wallet not found'];
            return back()->withNotify($notify);
        }


        if ($method->min_limit/$currency->rate >  $request->amount || $method->max_limit/$currency->rate <  $request->amount) {
            $notify[] = ['error', 'Please follow the limits'];
            return back()->withNotify($notify);
        }

        if ($request->amount > $wallet->balance) {
            $notify[] = ['error', 'You do not have sufficient balance for withdraw.'];
            return back()->withNotify($notify);
        }


        $charge = ($method->fixed_charge/$currency->rate) + ($request->amount * $method->percent_charge / 100);
        $finalAmount = $request->amount - $charge;


        $withdraw = new Withdrawal();
        $withdraw->method_id = $method->id;
        $withdraw->user_id = $user->id;
        $withdraw->user_type = userGuard()['type'];
        $withdraw->amount = $request->amount;
        $withdraw->rate = $currency->rate;
        $withdraw->currency_id = $currency->id;
        $withdraw->wallet_id = $wallet->id;
        $withdraw->currency = $currency->currency_code;
        $withdraw->charge = $charge;
        $withdraw->final_amount = $finalAmount;
        $withdraw->after_charge = $finalAmount;
        $withdraw->withdraw_information = $userMethod->user_data;
        $withdraw->trx = getTrx();
        $withdraw->save();
        session()->put('wtrx',$withdraw->trx);
        return redirect(route(strtolower(userGuard()['type']).'.withdraw.preview'));

    }



    public function withdrawSubmit(Request $request)
    {
        $request->validate([
            'otp_type'=>'nullable|in:email,sms,2fa'
          ]
        );
       $userAction = new UserActionProcess();
       $userAction->user_id = userGuard()['user']->id;
       $userAction->user_type = userGuard()['type'];
       $userAction->act = 'withdraw_money';
       $userAction->details = [
            'done_route'=>route(strtolower(userGuard()['type']).'.withdraw.submit.done'),
       ];
       $userAction->type = $request->otp_type;
       $userAction->submit();

       return redirect($userAction->next_route);
    }

    public function withdrawSubmitDone(){
        if(!session('wtrx')){
            $notify[]=['error','Sorry! something went  wrong'];
            return back()->withNotify($notify);
        }
        $withdraw = Withdrawal::with('method',strtolower(userGuard()['type']))->where('trx', session()->get('wtrx'))->where('status', 0)->orderBy('id','desc')->firstOrFail();

        $wallet = Wallet::checkWallet(['user'=>userGuard()['user'],'type'=>userGuard()['type']])->find($withdraw->wallet_id);
        if(!$wallet){
            $notify[]=['error','wallet not found'];
            return back()->withNotify($notify);
        }



        $withdraw->status = 2;
        $withdraw->save();

        $wallet->balance  -=  $withdraw->amount;
        $wallet->save();

        $transaction = new Transaction();
        $transaction->user_id = $withdraw->user_id;
        $transaction->user_type = $withdraw->user_type;
        $transaction->wallet_id = $wallet->id;
        $transaction->currency_id = $withdraw->currency_id;
        $transaction->before_charge = $withdraw->amount;
        $transaction->amount = $withdraw->amount;
        $transaction->post_balance = $wallet->balance;
        $transaction->charge = 0;
        $transaction->charge_type = '+';
        $transaction->trx_type = '-';
        $transaction->operation_type = 'withdraw_money';
        $transaction->details = 'Money withdrawal';
        $transaction->trx =  $withdraw->trx;
        $transaction->save();

        $adminNotification = new AdminNotification();
        $adminNotification->user_id = userGuard()['user']->id;
        $adminNotification->user_type = $withdraw->user_type;
        $adminNotification->title = 'New withdraw request from '.userGuard()['user']->username;
        $adminNotification->click_url = urlPath('admin.withdraw.details',$withdraw->id);
        $adminNotification->save();

        $general = GeneralSetting::first();

        notify(userGuard()['user'], 'WITHDRAW_REQUEST', [
            'method_name' => $withdraw->method->name,
            'method_currency' => $wallet->currency->currency_code,
            'method_amount' => showAmount($withdraw->final_amount,$general->currency),
            'amount' => showAmount($withdraw->amount,$general->currency),
            'charge' => showAmount($withdraw->charge,$general->currency),
            'currency' => $wallet->currency->currency_code,
            'trx' => $withdraw->trx,
            'post_balance' => showAmount($wallet->balance,$general->currency),
        ]);

        $notify[] = ['success', 'Withdraw request sent successfully'];
        return redirect()->route(strtolower(userGuard()['type']).'.withdraw.history')->withNotify($notify);
    }

}
